/**
 * @license
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { AggregateFunction, AliasedAggregate, Expression, Selectable } from '../lite-api/expressions';
import { VectorValue } from '../lite-api/vector_value';
export declare function selectablesToMap(selectables: Array<Selectable | string>): Map<string, Expression>;
export declare function aliasedAggregateToMap(aliasedAggregatees: AliasedAggregate[]): Map<string, AggregateFunction>;
/**
 * Converts a value to an Expression, Returning either a Constant, MapFunction,
 * ArrayFunction, or the input itself (if it's already an expression).
 *
 * @private
 * @internal
 * @param value
 */
export declare function vectorToExpr(value: VectorValue | number[] | Expression): Expression;
/**
 * Converts a value to an Expression, Returning either a Constant, MapFunction,
 * ArrayFunction, or the input itself (if it's already an expression).
 * If the input is a string, it is assumed to be a field name, and a
 * field(value) is returned.
 *
 * @private
 * @internal
 * @param value
 */
export declare function fieldOrExpression(value: unknown): Expression;
/**
 * Converts a value to an Expression, Returning either a Constant, MapFunction,
 * ArrayFunction, or the input itself (if it's already an expression).
 *
 * @private
 * @internal
 * @param value
 */
export declare function valueToDefaultExpr(value: unknown): Expression;
